package joyfill.internal

import joyfill.Document
import joyfill.Stage
import joyfill.toDocument
import joyfill.toField
import joyfill.toFormularDefinition
import joyfill.utils.ID
import joyfill.utils.listAt
import joyfill.utils.toNonNullableString
import kotlinx.datetime.Clock

@PublishedApi
internal class DocumentImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Document {
    override var id: String
        get() = wrapped[ID].toNonNullableString()
        set(value) {
            wrapped[ID] = value
        }

    override var stage: Stage?
        get() = (wrapped[Document::stage.name] as? String)?.let { Stage.valueOf(it) }
        set(value) {
            wrapped[Document::stage.name] = value?.name
        }

    override var identifier: String
        get() = wrapped[Document::identifier.name].toNonNullableString() ?: id
        set(value) {
            wrapped[Document::identifier.name] = value
        }

    override var name: String
        get() = (wrapped[Document::name.name] as? String).orEmpty()
        set(value) {
            wrapped[Document::name.name] = value
        }

    override val files = wrapped.listAt(Document::files) { FileImpl(it) }

    override val fields = wrapped.listAt(Document::fields) { it.toField() }

    override val formulas = wrapped.listAt(Document::formulas) { it.toFormularDefinition() }

    override val type: String get() = wrapped[Document::type.name].toNonNullableString()

    override val createdOn: Long get() = wrapped[Document::createdOn.name] as? Long ?: Clock.System.now().toEpochMilliseconds()

    override val deleted: Boolean get() = wrapped[Document::deleted.name] as? Boolean ?: false

    override fun <R> get(key: String): R = wrapped[key] as R

    override fun set(key: String, value: Any?) {
        wrapped[key] = value
    }

    override fun copy(): Document = toJsonString().toDocument()
}