package joyfill.file.internal

import joyfill.file.FileCell
import joyfill.file.FileColumn
import joyfill.file.FileSchema
import joyfill.utils.Attachment
import joyfill.utils.JsonList
import joyfill.utils.internal.AttachmentImpl

@PublishedApi
internal class FileCellImpl(
    override val column: FileColumn,
    private val wrapped: MutableMap<String, Any?>,
) : FileCell, FileSchema by column {
    override val value: MutableList<Attachment> by lazy {
        JsonList(
            parent = wrapped,
            key = column.id,
            factory = { AttachmentImpl(it) },
        )
    }

    override val multi: Boolean = column.multi
    override val file: String get() = wrapped[FileCell::file.name] as? String ?: ""
}