package joyfill.dropdown.internal

import joyfill.dropdown.DropdownField
import joyfill.internal.AbstractValueBasedField
import joyfill.utils.JsonList
import joyfill.utils.Option
import joyfill.utils.toOption

@PublishedApi
internal class DropdownFieldImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractValueBasedField<String>(wrapped), DropdownField {
    override val options: List<Option> by lazy {
        JsonList(
            parent = wrapped,
            key = DropdownField::options.name,
            factory = { it.toOption() },
        ).filter { !it.deleted }
    }
}