package joyfill.dropdown.internal

import joyfill.dropdown.DropdownColumn
import joyfill.table.internal.column.AbstractValueBasedColumn
import joyfill.utils.JsonList
import joyfill.utils.Option
import joyfill.utils.toOption

@PublishedApi
internal class DropdownColumnImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractValueBasedColumn<String>(wrapped), DropdownColumn {
    override val options: List<Option> by lazy {
        JsonList(
            parent = wrapped,
            key = DropdownColumn::options.name,
            factory = { it.toOption() },
        ).filter { !it.deleted }
    }
}