package joyfill.dropdown.internal

import joyfill.dropdown.DropdownCell
import joyfill.dropdown.DropdownColumn
import joyfill.dropdown.DropdownSchema

@PublishedApi
internal class DropdownCellImpl(
    override val column: DropdownColumn,
    private val wrapped: MutableMap<String, Any?>
) : DropdownCell, DropdownSchema by column {
    override var value: String?
        get() = wrapped[column.id] as? String
        set(value) {
            wrapped[column.id] = value
        }
}