package joyfill.date.internal

import joyfill.date.DateField
import joyfill.internal.AbstractValueBasedField
import joyfill.utils.TIME_ZONE
import joyfill.utils.toNullableLong
import joyfill.utils.toNullableString

@PublishedApi
internal class DateFieldImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractValueBasedField<Long>(wrapped), DateField {
    override var value: Long?
        get() = wrapped[DateField::value.name]?.toNullableLong()
        set(value) {
            wrapped[DateField::value.name] = value
        }

    override var timeZone: String?
        get() = wrapped[TIME_ZONE].toNullableString()
        set(value) {
            wrapped[TIME_ZONE] = value
        }
}