package joyfill.conditions.internal.table

import joyfill.conditions.internal.AbstractLogicImpl
import joyfill.conditions.table.TableConditionDefinition
import joyfill.conditions.table.TableLogic
import joyfill.utils.JsonList

@PublishedApi
internal class TableLogicImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractLogicImpl(wrapped), TableLogic {
    override val conditions: MutableList<TableConditionDefinition> by lazy {
        JsonList(
            parent = wrapped,
            key = TableLogic::conditions.name,
            factory = { TableConditionDefinitionImpl(it) },
        )
    }
}