package joyfill.conditions.internal.field

import joyfill.conditions.field.FieldConditionDefinition
import joyfill.conditions.field.FieldLogic
import joyfill.conditions.internal.AbstractLogicImpl
import joyfill.utils.JsonList

@PublishedApi
internal class FieldLogicImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractLogicImpl(wrapped), FieldLogic {
    override val conditions: MutableList<FieldConditionDefinition> by lazy {
        JsonList(
            parent = wrapped,
            key = FieldLogic::conditions.name,
            factory = { FieldConditionDefinitionImpl(it) },
        )
    }
}
