package joyfill.conditions.internal

import joyfill.conditions.AndEval
import joyfill.conditions.HideAction
import joyfill.conditions.Logic
import joyfill.conditions.OrEval
import joyfill.conditions.ShowAction
import joyfill.conditions.UnknownAction
import joyfill.conditions.UnknownEval
import joyfill.internal.AbstractMappable

@PublishedApi
internal abstract class AbstractLogicImpl(
    wrapped: MutableMap<String, Any?>
) : Logic, AbstractMappable(wrapped) {
    override val action get() = wrapped[Logic::action.name].toAction()
    override val eval get() = wrapped[Logic::eval.name].toEval()

    override var hidden: Boolean
        get() = wrapped[Logic::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Logic::hidden.name] = value
        }

    private fun Any?.toAction() = when (this) {
        "show" -> ShowAction
        "hide" -> HideAction
        else -> UnknownAction(this)
    }

    private fun Any?.toEval() = when (this) {
        "and" -> AndEval
        "or" -> OrEval
        else -> UnknownEval(this)
    }
}