package joyfill.collection.internal

import joyfill.collection.TableSchemas
import joyfill.internal.AbstractMappable
import joyfill.table.TableSchema

@PublishedApi
internal class TableSchemasImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), TableSchemas {
    override fun all(): List<TableSchema> = wrapped.map { (key, value) -> TableSchemaImpl(id = key, value as MutableMap<String, Any?>) }

    override fun table(key: String?): TableSchema? = all().find { it.id == key || it.title.contentEquals(key, ignoreCase = true) }

    override fun root(): TableSchema? = all().find { it.root }
}