package joyfill.collection.internal

import joyfill.collection.Children
import joyfill.collection.TableSchemas
import joyfill.table.Row
import joyfill.table.TableSchema
import joyfill.utils.internal.AbstractRowImpl

@PublishedApi
internal class RowImpl(
    schema: TableSchemas,
    table: TableSchema,
    wrapped: MutableMap<String, Any?>
) : AbstractRowImpl(table.columns, wrapped), Row {

    override val children: Children by lazy {
        if (wrapped[Row::children.name] == null) {
            wrapped[Row::children.name] = mutableMapOf<String, Any?>()
        }
        ChildrenImpl(schema, table, wrapped[Row::children.name] as MutableMap<String, Any?>)
    }
}