package joyfill.chart.internal

import joyfill.chart.Line
import joyfill.chart.Point
import joyfill.chart.toPoint
import joyfill.internal.AbstractMappable
import joyfill.utils.ID
import joyfill.utils.JsonList
import joyfill.utils.toNonNullableString

@PublishedApi
internal class LineImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Line {
    override val id: String get() = wrapped[ID].toNonNullableString()
    override var title: String?
        get() = wrapped[Line::title.name].toNonNullableString()
        set(value) {
            wrapped[Line::title.name] = value
        }
    override var description: String?
        get() = wrapped[Line::description.name].toNonNullableString()
        set(value) {
            wrapped[Line::description.name] = value
        }

    override val deleted: Boolean get() = wrapped[Line::deleted.name] as? Boolean ?: false
    override val points: MutableList<Point> by lazy {
        JsonList(
            parent = wrapped,
            key = Line::points.name,
            factory = { it.toPoint() },
        )
    }
} 