package joyfill.block.internal

import joyfill.block.BlockCell
import joyfill.block.BlockColumn
import joyfill.block.BlockSchema

@PublishedApi
internal class BlockCellImpl(
    override val column: BlockColumn,
    private val wrapped: MutableMap<String, Any?>
) : BlockCell, BlockSchema by column {
    override var value: String?
        get() = wrapped[column.id] as? String
        set(value) {
            wrapped[column.id] = value
        }
}


