package joyfill.barcode.internal

import joyfill.barcode.BarcodeField
import joyfill.components.Component
import joyfill.internal.AbstractValueBasedField
import joyfill.utils.toNonNullableString

@PublishedApi
internal class BarcodeFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), BarcodeField{
    override var value: String?
        get() = wrapped[Component::value.name].toNonNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}