package joyfill.barcode.internal

import joyfill.barcode.BarcodeCell
import joyfill.barcode.BarcodeColumn
import joyfill.barcode.BarcodeSchema
import joyfill.utils.toNonNullableString

@PublishedApi
internal class BarcodeCellImpl(
    override val column: BarcodeColumn,
    private val wrapped: MutableMap<String, Any?>
) : BarcodeCell, BarcodeSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNonNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}

