package joyfill

/**
 * Platform-specific resource loader for accessing schema files
 */
expect object ResourceLoader {
    /**
     * Loads a resource file as a string from the resources directory
     *
     * @param path The path to the resource file (e.g., "schemas/joyfill-schema-1-0-0.json")
     * @return The content of the file as a string, or null if not found
     */
    fun loadResource(path: String): String?

    /**
     * Lists all files in a resource directory
     *
     * @param path The path to the resource directory (e.g., "schemas/")
     * @return List of file names in the directory, or empty list if directory not found or empty
     */
    fun filesFrom(path: String): List<String>
}