package joyfill

import joyfill.barcode.toBarcodeField
import joyfill.block.toBlockField
import joyfill.chart.toChartField
import joyfill.collection.toCollectionField
import joyfill.components.ComponentSchema
import joyfill.date.toDateField
import joyfill.dropdown.toDropdownField
import joyfill.file.toFileField
import joyfill.image.toImageField
import joyfill.internal.DocumentImpl
import joyfill.internal.FieldPositionImpl
import joyfill.internal.FormularApplicationImpl
import joyfill.internal.FormularDefinitionImpl
import joyfill.internal.PageImpl
import joyfill.multi_select.toMultiSelectField
import joyfill.number.toNumberField
import joyfill.signature.toSignatureField
import joyfill.table.toTableField
import joyfill.text.toTextField
import joyfill.text_area.toTextAreaField
import joyfill.unknown.toUnknownField
import joyfill.utils.toMap
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonObject

// Document
inline fun MutableMap<String, Any?>.toDocument(): Document = DocumentImpl(this)
inline fun String.toDocuments(): List<Document> = Json.decodeFromString<JsonArray>(this).map {
    (it as JsonObject).toDocument()
}

inline fun String.toDocument(): Document = Json.decodeFromString<JsonObject>(this).toDocument()

inline fun JsonObject.toDocument(): Document = toMap().toDocument()

// Page
inline fun MutableMap<String, Any?>.toPage(): Page = PageImpl(this)

inline fun MutableMap<String, Any?>.toFieldPosition(): FieldPosition = FieldPositionImpl(this)

inline fun MutableMap<String, Any?>.toFormularDefinition(): FormulaDefinition = FormularDefinitionImpl(this)

inline fun MutableMap<String, Any?>.toFormularApplication(): FormularApplication = FormularApplicationImpl(this)

// Field
inline fun MutableMap<String, Any?>.toField(): Field = when (type()) {
    Type.text -> toTextField()
    Type.block -> toBlockField()
    Type.textarea -> toTextAreaField()
    Type.dropdown -> toDropdownField()
    Type.barcode -> toBarcodeField()
    Type.number -> toNumberField()
    Type.table -> toTableField()
    Type.collection -> toCollectionField()
    Type.chart -> toChartField()
    Type.image -> toImageField()
    Type.file -> toFileField()
    Type.multiSelect -> toMultiSelectField()
    Type.date -> toDateField()
    Type.signature -> toSignatureField()
    else -> toUnknownField()
}

// Field Position
inline fun MutableMap<String, Any?>.toPosition(): FieldPosition = FieldPositionImpl(this)

// Type
inline fun MutableMap<String, Any?>.type(): Type {
    val name = try {
        this[ComponentSchema::type.name] as String
    } catch (_: Throwable) {
        Type.unknown.name
    }
    return Type.valueOf(name)
}