package joyfill

interface Document : Mappable {
    var id: String
    var identifier: String
    var stage: Stage?
    var name: String
    val files: MutableList<File>
    val fields: MutableList<Field>
    val formulas: MutableList<FormulaDefinition>
    val type: String
    val createdOn: Long
    val deleted: Boolean

    fun set(key: String, value: Any?)
    fun <R> get(key: String): R

    fun copy(): Document
}

enum class DocumentType {
    template,
    document
}