package joyfill.tools.joyobject

import joyfill.utils.joyobject.JoyList
import joyfill.utils.joyobject.JoyMap
import joyfill.utils.joyobject.ListObject

internal data class MapObject(
    val wrapped: MutableMap<String, Any?>
) : JoyMap {
    override fun number(key: String): Double? = wrapped[key]?.toString()?.toDoubleOrNull()

    override fun string(key: String): String? = wrapped[key]?.toString()

    override fun boolean(key: String): Boolean? = wrapped[key]?.toString()?.toBooleanStrictOrNull()

    override fun array(key: String): JoyList? {
        val list = wrapped[key] as? MutableList<Any?> ?: return null
        return ListObject(list)
    }

    override fun obj(key: String): JoyMap? {
        val o = wrapped[key] as? MutableMap<String, Any?> ?: return null
        return MapObject(o)
    }

    override fun createEmptyArray(key: String): JoyList {
        wrapped[key] = mutableListOf<Any?>()
        return ListObject(wrapped[key] as MutableList<Any?>)
    }

    override fun createEmptyObject(key: String): JoyMap {
        wrapped[key] = mutableMapOf<String, Any?>()
        return MapObject(wrapped[key] as MutableMap<String, Any?>)
    }
}