package joyfill.utils.joyobject

sealed interface JoyLiteral : JoyObject {
    val value: Any?
}

data object JoyNull : JoyLiteral {
    override val value: Nothing? = null
    override fun toString(): String = "null"
}

data class JoyNumber(override val value: Double?) : JoyLiteral {
    override fun toString(): String = value.toString()
}

data class JoyString(override val value: String?) : JoyLiteral {
    override fun toString(): String = value.toString()
}

data class JoyBoolean(override val value: Boolean?) : JoyLiteral {
    override fun toString(): String = value.toString()
}