package joyfill.utils.internal

import joyfill.internal.AbstractMappable
import joyfill.table.Column
import joyfill.utils.ID
import joyfill.utils.Option
import joyfill.utils.joyobject.JoyMap
import joyfill.utils.joyobject.JoyObject
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableString


internal class OptionImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), Option {
    override val id: String by lazy { wrapped[ID].toNonNullableString() }
    override val deleted: Boolean by lazy { (wrapped[Option::deleted.name] as? Boolean) == true }
    override val value: String by lazy { wrapped[Option::value.name].toNonNullableString() }
    override val color: String? by lazy { wrapped[Option::color.name].toNullableString() }
    override val metadata: JoyMap by lazy {
        val key = Column::metadata.name
        val map = wrapped[key] as? MutableMap<String, Any?>
        if(map==null) {
            wrapped[key] = mutableMapOf<String,Any?>()
        }
        JoyObject(wrapped[key] as MutableMap<String, Any?>)
    }

    override fun equals(other: Any?): Boolean = other is Option && id == other.id
}