package joyfill.utils

import joyfill.utils.internal.AttachmentImpl
import joyfill.utils.internal.OptionImpl

fun Option(
    id: String,
    value: String,
    deleted: Boolean? = null,
    color: String? = null
): Option = mutableMapOf<String, Any?>(
    ID to id,
    Option::value.name to value,
    Option::deleted.name to deleted,
    Option::color.name to color
).toOption()

fun MutableMap<String, Any?>.toOption(): Option = OptionImpl(this)

fun Attachment(
    id: String,
    url: String,
    fileName: String? = null,
    filePath: String? = null,
    download: String? = null
): Attachment = buildMap<String, Any?> {
    put(ID, id)
    put(Attachment::url.name, url)
    if (fileName != null) put(Attachment::fileName.name, fileName)
    if (filePath != null) put(Attachment::filePath.name, filePath)
    if (download != null) put(Attachment::download.name, download)
}.toMutableMap().toAttachment()

fun MutableMap<String, Any?>.toAttachment(): Attachment = AttachmentImpl(this)