package joyfill.tooltip.internal

import joyfill.internal.AbstractMappable
import joyfill.tooltip.ToolTip
import joyfill.utils.TIP_DESCRIPTION
import joyfill.utils.TIP_TITLE
import joyfill.utils.TIP_VISIBLE
import joyfill.utils.toNonNullableString

internal class ToolTipImpl(
    private val wrapper: MutableMap<String, Any?>,
) : AbstractMappable(wrapper),
    ToolTip {

    override var title: String
        get() = wrapper[TIP_TITLE].toNonNullableString().orEmpty()
        set(value) {
            wrapper[TIP_TITLE] = value
        }

    override var visible: Boolean
        get() = wrapper[TIP_VISIBLE]?.toString()?.toBoolean() == true
        set(value) {
            wrapper[TIP_VISIBLE] = value
        }

    override var description: String
        get() = wrapper[TIP_DESCRIPTION].toNonNullableString().orEmpty()
        set(value) {
            wrapper[TIP_DESCRIPTION] = value
        }
}
