package joyfill.text.internal

import joyfill.components.Component
import joyfill.internal.AbstractValueBasedField
import joyfill.text.TextField
import joyfill.utils.toNonNullableString

@PublishedApi
internal class TextFieldImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractValueBasedField<String>(wrapped),
    TextField {
    override var value: String?
        get() = wrapped[Component::value.name].toNonNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}
