package joyfill.table.internal.column

import joyfill.internal.AbstractMappable
import joyfill.table.internal.table.ColumnVisualProperties
import joyfill.utils.ID
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableString

@PublishedApi
internal class ColumnVisualPropertiesImpl(wrapped: MutableMap<String, Any?>): AbstractMappable(wrapped), ColumnVisualProperties {
    override val id: String by lazy { wrapped[ID].toNonNullableString() }
    override val format by lazy { wrapped[ColumnVisualProperties::format.name].toNullableString() }
    override var hidden: Boolean
        get() = wrapped[ColumnVisualProperties::hidden.name]?.toString()?.lowercase()?.toBooleanStrictOrNull() == true
        set(value) {
            wrapped[ColumnVisualProperties::hidden.name] = value
        }
}