package joyfill.signature.internal

import joyfill.components.Component
import joyfill.internal.AbstractValueBasedField
import joyfill.signature.SignatureField
import joyfill.utils.toNonNullableString

@PublishedApi
internal class SignatureFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), SignatureField {
    override var value: String?
        get() = wrapped[Component::value.name].toNonNullableString()
        set(value) {
            wrapped[Component::value.name] = value
        }
}