package joyfill.signature.internal

import joyfill.signature.SignatureCell
import joyfill.signature.SignatureColumn
import joyfill.signature.SignatureSchema
import joyfill.utils.toNonNullableString

@PublishedApi
internal class SignatureCellImpl(
    override val column: SignatureColumn,
    private val wrapped: MutableMap<String, Any?>
) : SignatureCell, SignatureSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNonNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}