package joyfill.schemas.internal

import joyfill.Type
import joyfill.internal.AbstractMappable
import joyfill.schemas.Schema
import joyfill.utils.ID

abstract class AbstractSchema(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Schema {
    override var id: String
        get() = wrapped[ID].toString()
        set(value) {
            wrapped[ID] = value
        }

    override var required: Boolean
        get() = wrapped[Schema::required.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Schema::required.name] = value
        }

    override var type
        get() = Type.valueOf(wrapped[Schema::type.name].toString())
        set(value) {
            wrapped[Schema::type.name] = value
        }

    override var title: String
        get() = wrapped[Schema::title.name].toString()
        set(value) {
            wrapped[Schema::title.name] = value
        }

    override var hidden: Boolean
        get() = wrapped[Schema::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Schema::hidden.name] = value
        }
}