package joyfill.number.internal

import joyfill.internal.AbstractValueBasedField
import joyfill.number.NumberField
import joyfill.utils.toNullableDouble


@PublishedApi
internal class NumberFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<Double>(wrapped), NumberField {
    override var value: Double?
        get() = wrapped[NumberField::value.name]?.toNullableDouble()
        set(value) {
            wrapped[NumberField::value.name] = value
        }

}

