package joyfill.number.internal

import joyfill.number.NumberColumn
import joyfill.table.internal.column.AbstractValueBasedColumn
import joyfill.utils.toNullableDouble

@PublishedApi
internal class NumberColumnImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedColumn<Double>(wrapped), NumberColumn {
    override var value: Double?
        get() = wrapped[NumberColumn::value.name]?.toNullableDouble()
        set(value) {
            wrapped[NumberColumn::value.name] = value
        }
}