package joyfill.number.internal

import joyfill.number.NumberCell
import joyfill.number.NumberColumn
import joyfill.number.NumberSchema
import joyfill.utils.toNullableDouble

@PublishedApi
internal class NumberCellImpl(
    override val column: NumberColumn,
    private val wrapped: MutableMap<String, Any?>
) : NumberCell, NumberSchema by column {
    override var value: Double?
        get() = wrapped[column.id]?.toNullableDouble()
        set(value) {
            wrapped[column.id] = value
        }
}