package joyfill.multi_select.internal

import joyfill.internal.AbstractField
import joyfill.multi_select.MultiSelectField
import joyfill.utils.JsonList
import joyfill.utils.Option
import joyfill.utils.toOption

@PublishedApi
internal class MultiSelectFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractField(wrapped), MultiSelectField {
    override val multi by lazy {
        wrapped[MultiSelectField::multi.name]?.toString()?.toBoolean() ?: true
    }

    override val options: List<Option> by lazy {
        JsonList(
            parent = wrapped,
            key = MultiSelectField::options.name,
            factory = { it.toOption() },
        )
    }


    override val value: MutableList<String> = run {
        val key = MultiSelectField::value.name
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }
}