package joyfill.multi_select.internal

import joyfill.multi_select.MultiSelectCell
import joyfill.multi_select.MultiSelectColumn
import joyfill.multi_select.MultiSelectSchema
import joyfill.utils.Option

@PublishedApi
internal class MultiSelectCellImpl(
    override val column: MultiSelectColumn,
    private val wrapped: MutableMap<String, Any?>
) : MultiSelectCell, MultiSelectSchema by column {

    override val multi = column.multi

    override val value: MutableList<String> by lazy {
        val key = column.id
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }

    override val options: List<Option> = column.options
}