package joyfill.internal

import joyfill.Page
import joyfill.View
import joyfill.toPage
import joyfill.utils.ID
import joyfill.utils.JsonList
import joyfill.utils.toNonNullableString

@PublishedApi
internal class ViewImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractMappable(wrapped), View {
    override val id: String by lazy { wrapped[ID].toNonNullableString() }
    override val type: String by lazy { wrapped[View::type.name].toNonNullableString() }
    override val pages: MutableList<Page> by lazy {
        JsonList(
            parent = wrapped,
            key = View::pages.name,
            factory = { it.toPage() },
        )
    }
    override val pageOrder: MutableList<String> = run {
        val key = View::pageOrder.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }

}