package joyfill.internal

import joyfill.FormularApplication
import joyfill.FormularTarget
import joyfill.utils.ID

@PublishedApi
internal class
FormularApplicationImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), FormularApplication {
    override val id: String by lazy { wrapped[ID].toString() }
    override val formula: String by lazy { wrapped[FormularApplication::formula.name].toString() }
    override val key: FormularTarget by lazy {
        try {
            FormularTarget.valueOf(wrapped[FormularApplication::key.name] as String)
        } catch (_: Throwable) {
            FormularTarget.Value
        }
    }
}