package joyfill.internal

import joyfill.FieldPosition
import joyfill.table.internal.table.ColumnVisualProperties
import joyfill.table.toColumnVisualProperties
import joyfill.utils.COLUMNS
import joyfill.utils.ID
import joyfill.utils.toNonNullableString
import joyfill.utils.toNullableDouble
import joyfill.utils.toNullableString

@PublishedApi
internal class FieldPositionImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), FieldPosition {
    override val id: String by lazy { wrapped[ID].toNonNullableString() }
    override val field: String by lazy { wrapped[FieldPosition::field.name].toNonNullableString() }
    override val displayType: String? by lazy { wrapped[FieldPosition::displayType.name].toNonNullableString() }
    override val y: Double by lazy { wrapped[FieldPosition::y.name]?.toNullableDouble() ?: 0.0 }
    override val x: Double by lazy { wrapped[FieldPosition::x.name]?.toNullableDouble() ?: 0.0 }
    override val format: String? by lazy { wrapped[FieldPosition::format.name].toNullableString() }
    override val fontColor: String? by lazy { wrapped[FieldPosition::fontColor.name].toNullableString() }
    override val fontWeight: String? by lazy { wrapped[FieldPosition::fontWeight.name].toNullableString() }
    override val primaryDisplayOnly: Boolean? by lazy { wrapped[FieldPosition::primaryDisplayOnly.name] as? Boolean }
    override val fontSize: Double? by lazy { wrapped[FieldPosition::fontSize.name]?.toNullableDouble() }
    override val textTransform: String? by lazy { wrapped[FieldPosition::textTransform.name].toNullableString() }
    override val textOverflow: String? by lazy { wrapped[FieldPosition::textOverflow.name].toNullableString() }
    override val textAlign: String? by lazy { wrapped[FieldPosition::textAlign.name].toNullableString() }
    override val type: String by lazy { wrapped[FieldPosition::type.name].toNonNullableString() }
    override val borderColor: String? by lazy { wrapped[FieldPosition::borderColor.name].toNullableString() }
    override val backgroundColor: String? by lazy { wrapped[FieldPosition::backgroundColor.name].toNullableString() }
    override val borderRadius: Double? by lazy { wrapped[FieldPosition::borderRadius.name]?.toNullableDouble() }
    override val borderWidth: Double? by lazy { wrapped[FieldPosition::borderWidth.name]?.toNullableDouble() }
    override val padding: Double? by lazy { wrapped[FieldPosition::padding.name]?.toNullableDouble() }
    override val titleDisplay: String? by lazy { wrapped[FieldPosition::titleDisplay.name].toNullableString() }
    override val fontStyle: String? by lazy { wrapped[FieldPosition::fontStyle.name].toNullableString() }
    override val textDecoration: String? by lazy { wrapped[FieldPosition::textDecoration.name].toNullableString() }
    override val height: Double by lazy { wrapped[FieldPosition::height.name]?.toNullableDouble() ?: 0.0 }
    override val width: Double by lazy { wrapped[FieldPosition::width.name]?.toNullableDouble() ?: 0.0 }
    override val columns: List<ColumnVisualProperties> by lazy {
        val data = wrapped[COLUMNS] as? Map<String, Any?> ?: emptyMap()
        data.map { (columnId, columnData) ->
            val columnMap = columnData as? MutableMap<String, Any?> ?: mutableMapOf()
            val fullColumnMap = mutableMapOf<String, Any?>(
                ID to columnId,
                ColumnVisualProperties::format.name to columnMap["format"],
                ColumnVisualProperties::hidden.name to columnMap["hidden"]
            )
            fullColumnMap.toColumnVisualProperties()
        }
    }
}