package joyfill.internal

import joyfill.components.Component

@PublishedApi
internal abstract class AbstractValueBasedField<V>(
    wrapped: MutableMap<String, Any?>,
) : AbstractField(wrapped),
    Component {
    override var value: V?
        get() = wrapped[Component::value.name] as? V
        set(value) {
            wrapped[Component::value.name] = value
        }
}
