package joyfill.internal

import joyfill.Mappable
import joyfill.components.Component
import joyfill.utils.JsonList

@PublishedApi
internal abstract class AbstractListBasedField<V : Mappable>(
    wrapped: MutableMap<String, Any?>,
) : AbstractField(wrapped), Component {
    abstract fun factory(map: MutableMap<String, Any?>): V
    override val value: MutableList<V> by lazy {
        JsonList(
            factory = ::factory,
            parent = wrapped,
            key = Component::value.name,
        )
    }
}