package joyfill.internal

import joyfill.Field
import joyfill.conditions.field.FieldLogic
import joyfill.conditions.internal.field.FieldLogicImpl
import joyfill.schemas.internal.AbstractSchema
import joyfill.table.Column
import joyfill.toFormularApplication
import joyfill.tooltip.ToolTip
import joyfill.tooltip.internal.ToolTipImpl
import joyfill.utils.ID
import joyfill.utils.TIP_DESCRIPTION
import joyfill.utils.TIP_TITLE
import joyfill.utils.TIP_VISIBLE
import joyfill.utils.joyobject.JoyMap
import joyfill.utils.joyobject.JoyObject
import joyfill.utils.listAt
import joyfill.utils.toNonNullableString

internal abstract class AbstractField(
    wrapped: MutableMap<String, Any?>,
) : AbstractSchema(wrapped),
    Field {
    override var id: String
        get() = wrapped[ID].toNonNullableString()
        set(value) {
            wrapped[ID] = value
        }

    override var title: String
        get() = wrapped[Field::title.name].toNonNullableString()
        set(value) {
            wrapped[Field::title.name] = value
        }

    override var identifier: String
        get() = wrapped[Field::identifier.name].toNonNullableString()
        set(value) {
            wrapped[Field::identifier.name] = value
        }

    override val disabled: Boolean
        get() = wrapped[Field::disabled.name]?.toString()?.toBoolean() == true

    override var hidden: Boolean
        get() = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Field::hidden.name] = value
        }

    override val initialHiddenState: Boolean = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true

    override val tip: ToolTip? by lazy {
        ToolTipImpl(
            mutableMapOf(
                TIP_TITLE to wrapped[TIP_TITLE] as? String,
                TIP_DESCRIPTION to wrapped[TIP_DESCRIPTION] as? String,
                TIP_VISIBLE to (wrapped[TIP_VISIBLE]?.toString()?.toBoolean() == true)
            )
        )
    }

    override val logic: FieldLogic? by lazy {
        wrapped[Field::logic.name]?.let { FieldLogicImpl(it as MutableMap<String, Any?>) }
    }

    override val formulas = wrapped.listAt(Field::formulas) { it.toFormularApplication() }

    override val metadata: JoyMap by lazy {
        val key = Column::metadata.name
        val map = wrapped[key] as? MutableMap<String, Any?>
        if (map == null) {
            wrapped[key] = mutableMapOf<String, Any?>()
        }
        JoyObject(wrapped[key] as MutableMap<String, Any?>)
    }
}
