package joyfill.image.internal

import joyfill.image.ImageField
import joyfill.internal.AbstractListBasedField
import joyfill.utils.Attachment
import joyfill.utils.toAttachment

@PublishedApi
internal class ImageFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Attachment>(wrapped), ImageField {
    override fun factory(map: MutableMap<String, Any?>): Attachment = map.toAttachment()
    override val multi: Boolean by lazy {
        wrapped[ImageField::multi.name]?.toString()?.toBooleanStrictOrNull() ?: false
    }
    override val file: String by lazy {
        wrapped[ImageField::file.name] as? String ?: ""
    }
}