package joyfill.image.internal

import joyfill.file.FileField
import joyfill.image.ImageColumn
import joyfill.table.internal.column.AbstractListBasedColumn
import joyfill.utils.Attachment
import joyfill.utils.toAttachment

@PublishedApi
internal class ImageColumnImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedColumn<Attachment>(wrapped), ImageColumn {
    override fun factory(map: MutableMap<String, Any?>): Attachment = map.toAttachment()
    override val multi by lazy {
        wrapped[FileField::multi.name]?.toString()?.toBooleanStrictOrNull() ?: false
    }
}