package joyfill.image.internal

import joyfill.image.ImageCell
import joyfill.image.ImageColumn
import joyfill.image.ImageSchema
import joyfill.utils.Attachment
import joyfill.utils.JsonList
import joyfill.utils.internal.AttachmentImpl

@PublishedApi
internal class ImageCellImpl(
    override val column: ImageColumn,
    private val wrapped: MutableMap<String, Any?>,
) : ImageCell, ImageSchema by column {
    override val value: MutableList<Attachment> by lazy {
        JsonList(
            parent = wrapped,
            key = ImageCell::value.name,
            factory = { AttachmentImpl(it) },
        )
    }

    override val multi: Boolean = column.multi
    override val file: String get() = wrapped[ImageCell::file.name] as? String ?: ""
}