package joyfill.file.internal

import joyfill.file.FileField
import joyfill.internal.AbstractListBasedField
import joyfill.utils.Attachment
import joyfill.utils.toAttachment

@PublishedApi
internal class FileFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Attachment>(wrapped), FileField {
    override fun factory(map: MutableMap<String, Any?>): Attachment = map.toAttachment()
    override val multi: Boolean by lazy {
        wrapped[FileField::multi.name]?.toString()?.toBooleanStrictOrNull() ?: false
    }
    override val file: String get() = wrapped[FileField::file.name] as? String ?: ""
}