package joyfill.file.internal

import joyfill.file.FileColumn
import joyfill.table.internal.column.AbstractListBasedColumn
import joyfill.utils.Attachment
import joyfill.utils.toAttachment

@PublishedApi
internal class FileColumnImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedColumn<Attachment>(wrapped), FileColumn {
    override fun factory(map: MutableMap<String, Any?>): Attachment = map.toAttachment()
    override val multi by lazy {
        wrapped[FileColumn::multi.name]?.toString()?.toBooleanStrictOrNull() ?: false
    }
}