package joyfill.date.internal

import joyfill.date.DateCell
import joyfill.date.DateColumn
import joyfill.date.DateSchema

@PublishedApi
internal class DateCellImpl(
    override val column: DateColumn,
    private val wrapped: MutableMap<String, Any?>
) : DateCell, DateSchema by column {
    override var value: Long?
        get() = wrapped[column.id] as? Long
        set(value) {
            wrapped[column.id] = value
        }
}