package joyfill.conditions.internal

import joyfill.conditions.Condition
import joyfill.conditions.ConditionDefinition
import joyfill.conditions.Contains
import joyfill.conditions.Empty
import joyfill.conditions.Equals
import joyfill.conditions.Filled
import joyfill.conditions.GreaterThan
import joyfill.conditions.LessThan
import joyfill.conditions.NotEquals
import joyfill.conditions.UnknownConditionOperator
import joyfill.internal.AbstractMappable

@PublishedApi
internal abstract class AbstractConditionDefinitionImpl(
    wrapped: MutableMap<String, Any?>
): AbstractMappable(wrapped), ConditionDefinition {
    override val value by lazy { wrapped[ConditionDefinition::value.name] }

    override val condition by lazy {
        wrapped[ConditionDefinition::condition.name].toOperator()
    }

    private fun Any?.toOperator() = when (this) {
        Condition.Filled.notation -> Filled
        Condition.Empty.notation -> Empty
        Condition.Equals.notation -> Equals
        Condition.NotEquals.notation -> NotEquals
        Condition.Contains.notation -> Contains
        Condition.GreaterThan.notation -> GreaterThan
        Condition.LessThan.notation -> LessThan
        else -> UnknownConditionOperator(this)
    }
}
