package joyfill.collection.internal

import joyfill.Field
import joyfill.conditions.internal.table.TableLogicImpl
import joyfill.conditions.table.TableLogic
import joyfill.schemas.internal.AbstractSchema
import joyfill.table.Column
import joyfill.table.TableSchema
import joyfill.table.toColumn
import joyfill.utils.COLUMNS
import joyfill.utils.JsonList

@PublishedApi
internal class TableSchemaImpl(
    override var id: String,
    wrapped: MutableMap<String, Any?>,
) : AbstractSchema(wrapped), TableSchema {
    override var root: Boolean
        get() = wrapped[TableSchema::root.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[TableSchema::root.name] = value
        }

    override var columns: MutableList<Column>
        get() = JsonList(parent = wrapped, key = COLUMNS, factory = { it.toColumn() })
        set(value) {
            wrapped[COLUMNS] = value
        }

    override var children: MutableList<String>
        get() = wrapped[TableSchema::children.name] as? MutableList<String> ?: mutableListOf()
        set(value) {
            wrapped[TableSchema::children.name] = value
        }

    override val tableLogic: TableLogic? get() = wrapped[Field::logic.name]?.let { TableLogicImpl(it as MutableMap<String, Any?>) }
}