package joyfill.collection.internal

import joyfill.collection.CollectionField
import joyfill.collection.TableSchemas
import joyfill.internal.AbstractListBasedField
import joyfill.table.Row

@PublishedApi
internal class CollectionFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Row>(wrapped), CollectionField {

    override fun factory(map: MutableMap<String, Any?>) = RowImpl(
        schema = schema,
        table = schema.root() ?: error("Collection field $title with id $id doesn't have a root table"),
        wrapped = map
    )

    override val schema: TableSchemas by lazy {
        TableSchemasImpl(wrapped[CollectionField::schema.name] as MutableMap<String, Any?>)
    }
}