package joyfill.collection.internal

import joyfill.collection.Child
import joyfill.collection.Children
import joyfill.collection.TableSchemas
import joyfill.internal.AbstractMappable
import joyfill.table.TableSchema

@PublishedApi
internal class ChildrenImpl(
    private val schema: TableSchemas,
    private val table: TableSchema,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Children {

    private val cache by lazy { mutableMapOf<String, Child>() }

    override fun find(key: String?): Child? = schema.table(key)?.toChild()

    override fun all(): List<Child> = schema.all().filter { it.id in table.children }.map { it.toChild() }

    private fun TableSchema.toChild(): Child = cache.getOrPut(id) {
        if (wrapped[id] == null) {
            wrapped[id] = mutableMapOf<String, Any?>()
        }
        ChildImpl(schema, this, wrapped[id] as MutableMap<String, Any?>)
    }
}