package joyfill.collection.internal

import joyfill.collection.Child
import joyfill.collection.TableSchemas
import joyfill.schemas.internal.AbstractSchema
import joyfill.table.Row
import joyfill.table.TableSchema
import joyfill.utils.JsonList

internal class ChildImpl(
    private val schema: TableSchemas,
    private val table: TableSchema,
    wrapped: MutableMap<String, Any?>,
) : AbstractSchema(wrapped), Child {

    override val value: MutableList<Row> by lazy {
        JsonList(
            parent = wrapped,
            key = Child::value.name,
            factory = { RowImpl(schema, table, it) },
        )
    }
}